declare @StrSql				nvarchar(4000)
declare @FW50_LIVELLO1_GEST	nchar(3)
declare @FW50_LIVELLO2_GEST	nchar(3)
declare @FW50_LIVELLO3_GEST	nchar(3)
declare @FW50_LIVELLO1_PROF	nchar(3)
declare @FW50_LIVELLO2_PROF	nchar(3)
declare @FW50_LIVELLO3_PROF	nchar(3)
declare @FW50_LIVELLO1		nchar(3)
declare @FW50_LIVELLO2		nchar(3)
declare @FW50_LIVELLO3		nchar(3)
declare @FW50_LIVELLO4		nchar(3)
declare @FW50_LIVELLO4_NEW	nchar(3)
declare @FW50_NOME_PREC_GEST nvarchar(60)
declare @FW50_NOME_PREC_PROF nvarchar(60)
declare @FW50_NOME_PREC		nvarchar(60)
declare @FW50_NOME_NEW		nvarchar(60)
declare @EsisteMenu			tinyint
declare @CicloMenu			tinyint
declare @InsContProf		tinyint
declare @FW50_IDVOCETS		smallint
declare @FW5F_IDVOCEMENU	smallint
declare @FW50_CCVR			varchar(12)
declare @FW5F_CCVR			varchar(12)
declare @FW5F_CCVR_GEST		varchar(12)
declare @FW5F_CCVR_PROF		varchar(12)
declare @FW50_DESCR			varchar(62)
declare @FW50_PARAM			varchar(257)
declare @FW50_ALIAS			varchar(12)
declare @FW50_HELPFILE		varchar(257)
declare @FW50_CODLICSTART	varchar(7)
declare @FW50_CODLICEND		varchar(7)
declare @FW5F_DATAINS		varchar(12)
declare @FW5F_DATAMOD		varchar(12)
declare @FW5F_RELEASE		varchar(10)
declare @FW5F_RELEASEA		varchar(10)
declare @FW50_FLGDITTA		varchar(3)
declare @FW50_INDTIPO		varchar(3)
declare @FW50_INDEXEC		varchar(3)
declare @FW5F_FLGVISIBLE	varchar(3)

set dateformat dmy

set @InsContProf = 2 --1(solo contabilit generale), 2(anche contabilit professionisti)

set @FW50_LIVELLO1_GEST = '10' --Amministrazione
set @FW50_LIVELLO2_GEST = '07' --Contabilit generale e IVA
set @FW50_LIVELLO3_GEST = '04' --Elaborazioni IVA
set @FW5F_CCVR_GEST = '''38241EE8B5''' --Codice controllo licenza FW5F
set @FW50_NOME_PREC_GEST = 'CGUO_DATMIVA19_SE.CLSCG_DATMIVA19_SE' --Nome men sotto il quale inserire quello nuovo (nel caso in cui non esiste inserisco il nuovo men come ultimo del livello)

set @FW50_LIVELLO1_PROF = '10' --Amministrazione
set @FW50_LIVELLO2_PROF = '08' --Contabilit professionisti ed IVA
set @FW50_LIVELLO3_PROF = '02' --Elaborazioni IVA
set @FW5F_CCVR_PROF = '''38241EE8B5''' --Codice controllo licenza FW5F
set @FW50_NOME_PREC_PROF = @FW50_NOME_PREC_GEST --Nome men sotto il quale inserire quello nuovo (nel caso in cui non esiste inserisco il nuovo men come ultimo del livello)

set @FW50_IDVOCETS = 2927 --IDVOCETS
set @FW50_DESCR = '''Modello IVA''' --Descrizione nuovo men
set @FW50_NOME_NEW = 'CGUO_ELABIVASAAS.CLSCG_ELABIVASAAS' --Nome nuovo men

set @FW50_CCVR = '''CDB2D24E55''' --Codice controllo licenza FW50
set @FW50_PARAM = 'NULL' --eventuale parametro
set @FW50_ALIAS = '''MODIVASAAS''' --Alias
set @FW50_HELPFILE = '''Coge.chm''' --HelpFile
set @FW50_CODLICSTART = '4001' --Licenza attivazione
set @FW50_CODLICEND = 'NULL' --Licenza disattivazione
set @FW50_INDTIPO = '3'	-- 1=interattivo, 2=stampa, 3=elaborazione
set @FW50_INDEXEC = '2'
set @FW50_FLGDITTA = '1' --Richiesta azienda

set @FW5F_DATAINS = right('00' + cast(day(getdate()) as nvarchar(2)),2) + '/' +  right('00' + cast(month(getdate()) as nvarchar(2)),2) + '/' + right('0000' + cast(year(getdate()) as nvarchar(4)),4)
set @FW5F_DATAMOD = @FW5F_DATAINS
set @FW5F_RELEASE = '''07.00.01'''
set @FW5F_RELEASEA = 'NULL' --'''RELEASEA'''
set @FW5F_FLGVISIBLE = '1' --Visibile

set nocount on

--NUOVA GESTIONE MENU' > 05.00.03

set @StrSql = N'SELECT @EsisteMenu = COUNT(1) FROM FW50_PROGRAMMI WITH(NOLOCK) WHERE FW50_NOME = @FW50_NOME_NEW'
EXECUTE sp_executesql @StrSql,
						N'@FW50_NOME_NEW nvarchar(60), @EsisteMenu tinyint OUTPUT',
						@FW50_NOME_NEW = @FW50_NOME_NEW, @EsisteMenu = @EsisteMenu OUTPUT

if @EsisteMenu = 0 
begin
	set @StrSql = N' INSERT INTO FW50_PROGRAMMI (FW50_IDVOCETS,FW50_NOME,FW50_DESCR,FW50_PARAM,FW50_INDTIPO,FW50_INDEXEC,FW50_INDMAXIM,FW50_FLGDITTA,FW50_ALIAS,FW50_HELPFILE,FW50_CODLICSTART,FW50_CODLICEND,FW50_CCVR,FW50_FLGSCHED,FW50_PATHEXE,FW50_FLGPERS,FW50_FLGPARAMREADY)' +
					' VALUES (@FW50_IDVOCETS,''' + @FW50_NOME_NEW + ''',' + @FW50_DESCR + ', ' + @FW50_PARAM + ',' + @FW50_INDTIPO + ',' + @FW50_INDEXEC + ',0,' + @FW50_FLGDITTA + ',' + @FW50_ALIAS + ',' + @FW50_HELPFILE + ',' + @FW50_CODLICSTART + ',' + @FW50_CODLICEND + ',' + @FW50_CCVR + ',0, Null,0,0)'

	EXECUTE sp_executesql @StrSql,
							N'@FW50_IDVOCETS smallint',
							@FW50_IDVOCETS = @FW50_IDVOCETS
end

set @CicloMenu = 1
while @CicloMenu <= @InsContProf
begin
	if @CicloMenu = 1
	begin
		set @FW50_LIVELLO1 = @FW50_LIVELLO1_GEST
		set @FW50_LIVELLO2 = @FW50_LIVELLO2_GEST
		set @FW50_LIVELLO3 = @FW50_LIVELLO3_GEST
		set @FW5F_CCVR = @FW5F_CCVR_GEST
		set @FW50_NOME_PREC = @FW50_NOME_PREC_GEST
	end
	else
	begin
		if @CicloMenu = 2
		begin
			set @FW50_LIVELLO1 = @FW50_LIVELLO1_PROF
			set @FW50_LIVELLO2 = @FW50_LIVELLO2_PROF
			set @FW50_LIVELLO3 = @FW50_LIVELLO3_PROF
			set @FW5F_CCVR = @FW5F_CCVR_PROF
			set @FW50_NOME_PREC = @FW50_NOME_PREC_PROF
		end
	end

	set @FW50_LIVELLO4 = ''
	set @FW50_LIVELLO4_NEW = ''
	set @EsisteMenu = 0

	/*Controllo l'esistenza del nuovo men: in tal caso non eseguo niente*/
	set @StrSql = N'SELECT @EsisteMenu = COUNT(1) FROM FW50_MODMENU WITH(NOLOCK) WHERE FW50_LIVELLO1 = @FW50_LIVELLO1 AND FW50_LIVELLO2 = @FW50_LIVELLO2 AND FW50_LIVELLO3 = @FW50_LIVELLO3 AND FW50_NOME = @FW50_NOME_NEW'
	EXECUTE sp_executesql @StrSql,
							N'@FW50_LIVELLO1 nchar(3), @FW50_LIVELLO2 nchar(3), @FW50_LIVELLO3 nchar(3), @FW50_NOME_NEW nvarchar(60), @EsisteMenu tinyint OUTPUT',
							@FW50_LIVELLO1 = @FW50_LIVELLO1, @FW50_LIVELLO2 = @FW50_LIVELLO2, @FW50_LIVELLO3 = @FW50_LIVELLO3, @FW50_NOME_NEW = @FW50_NOME_NEW, @EsisteMenu = @EsisteMenu OUTPUT

	if @EsisteMenu = 0 
	begin

		/*Seleziono il 4 livello del men sotto il quale devo inserire il nuovo men*/
		set @StrSql = N'SELECT @FW50_LIVELLO4 = FW50_LIVELLO4 FROM FW50_MODMENU WITH(NOLOCK) WHERE FW50_LIVELLO1 = @FW50_LIVELLO1 AND FW50_LIVELLO2 = @FW50_LIVELLO2 AND FW50_LIVELLO3 = @FW50_LIVELLO3 AND FW50_NOME = @FW50_NOME'
		EXECUTE sp_executesql @StrSql,
								N'@FW50_LIVELLO1 nchar(3), @FW50_LIVELLO2 nchar(3), @FW50_LIVELLO3 nchar(3), @FW50_NOME nvarchar(60), @FW50_LIVELLO4 nchar(3) OUTPUT',
								@FW50_LIVELLO1 = @FW50_LIVELLO1, @FW50_LIVELLO2 = @FW50_LIVELLO2, @FW50_LIVELLO3 = @FW50_LIVELLO3, @FW50_NOME = @FW50_NOME_PREC, @FW50_LIVELLO4 = @FW50_LIVELLO4 OUTPUT

		if LTRIM(RTRIM(ISNULL(@FW50_LIVELLO4,''))) <> ''
		begin

			/*Aggiorno il 4 livello dei men successivi a quello sotto il quale devo inserire il nuovo men in modo da crearmi un "buco"*/
			set @StrSql = N' 
				declare @StrSql			nvarchar(4000)
				declare @CODICE			decimal(6)
				declare	@LIVELLO4		char(3)

				declare CURSOR_FW50_MODMENU cursor for 
				SELECT FW50_CODICE, CASE WHEN CAST(FW50_LIVELLO4 AS DECIMAL(3)) + 1 >= 10 THEN CAST(CAST(FW50_LIVELLO4 AS DECIMAL(3)) + 1 AS CHAR(3)) ELSE ''0'' + CAST(CAST(FW50_LIVELLO4 AS DECIMAL(3)) + 1 AS CHAR(3)) END AS FW50_LIVELLO4
				FROM FW50_MODMENU
				WHERE FW50_LIVELLO1 = @FW50_LIVELLO1
					AND FW50_LIVELLO2 = @FW50_LIVELLO2
					AND FW50_LIVELLO3 = @FW50_LIVELLO3
					AND CAST(FW50_LIVELLO4 AS DECIMAL(3)) > CAST(@FW50_LIVELLO4 AS DECIMAL(3))
				ORDER BY CAST(FW50_LIVELLO4 AS DECIMAL(3)) DESC 


				OPEN CURSOR_FW50_MODMENU FETCH NEXT FROM CURSOR_FW50_MODMENU INTO @CODICE, @LIVELLO4

				WHILE (@@FETCH_STATUS = 0)
				BEGIN

					set @StrSql = N'' UPDATE FW5F_MENU'' +
									'' SET FW5F_LIVELLO4 = '''''' + (CASE WHEN CAST(@LIVELLO4 AS DECIMAL(3)) < 10 THEN ''0'' ELSE '''' END) + RTRIM(LTRIM(CAST(CAST(@LIVELLO4 AS DECIMAL(3)) AS NCHAR(3)))) + '''''''' +
									'' WHERE FW5F_CODICE = '' + CAST(@CODICE AS NVARCHAR(6))
							   
					EXECUTE(@StrSql)

					FETCH NEXT FROM CURSOR_FW50_MODMENU INTO @CODICE, @LIVELLO4
				END 

				CLOSE CURSOR_FW50_MODMENU
				DEALLOCATE CURSOR_FW50_MODMENU	
				'

			EXECUTE sp_executesql @StrSql,
									N'@FW50_LIVELLO1 nchar(3), @FW50_LIVELLO2 nchar(3), @FW50_LIVELLO3 nchar(3), @FW50_LIVELLO4 nchar(3)',
									@FW50_LIVELLO1 = @FW50_LIVELLO1, @FW50_LIVELLO2 = @FW50_LIVELLO2, @FW50_LIVELLO3 = @FW50_LIVELLO3, @FW50_LIVELLO4 = @FW50_LIVELLO4
				
			set @FW50_LIVELLO4_NEW = CAST(CAST(@FW50_LIVELLO4 AS DECIMAL(3)) + 1 AS NCHAR(3))
		end

		if LTRIM(RTRIM(ISNULL(@FW50_LIVELLO4_NEW,''))) = ''
		begin
			set @StrSql = N'SELECT @FW50_LIVELLO4_NEW = CAST(MAX(CAST(FW50_LIVELLO4 AS DECIMAL(3)))+1 AS NCHAR(3)) FROM FW50_MODMENU WITH(NOLOCK) WHERE FW50_LIVELLO1 = @FW50_LIVELLO1 AND FW50_LIVELLO2 = @FW50_LIVELLO2 AND FW50_LIVELLO3 = @FW50_LIVELLO3'
			EXECUTE sp_executesql @StrSql,
									N'@FW50_LIVELLO1 nchar(3), @FW50_LIVELLO2 nchar(3), @FW50_LIVELLO3 nchar(3), @FW50_LIVELLO4_NEW nchar(3) OUTPUT',
									@FW50_LIVELLO1 = @FW50_LIVELLO1, @FW50_LIVELLO2 = @FW50_LIVELLO2, @FW50_LIVELLO3 = @FW50_LIVELLO3, @FW50_LIVELLO4_NEW = @FW50_LIVELLO4_NEW OUTPUT
		end

		if LTRIM(RTRIM(ISNULL(@FW50_LIVELLO4_NEW,''))) <> ''
		begin
				
			set @FW50_LIVELLO4_NEW = (CASE WHEN CAST(@FW50_LIVELLO4_NEW AS DECIMAL(3)) >= 10 THEN CAST(CAST(@FW50_LIVELLO4_NEW AS DECIMAL(3)) AS NCHAR(3)) ELSE '0' + CAST(CAST(@FW50_LIVELLO4_NEW AS DECIMAL(3)) AS NCHAR(3)) END)

			set @StrSql = N'(SELECT @FW5F_IDVOCEMENU = MAX(FW5F_IDVOCEMENU) + 1 FROM FW5F_MENU WITH(NOLOCK) WHERE FW5F_IDVOCEMENU < 5000)'
			execute sp_executesql @StrSql,
									N'@FW5F_IDVOCEMENU int OUTPUT',
									@FW5F_IDVOCEMENU = @FW5F_IDVOCEMENU OUTPUT

			set @StrSql = N' INSERT INTO FW5F_MENU (FW5F_IDVOCEMENU,FW5F_FLGSTDPERS1,FW5F_LIVELLO1,FW5F_FLGSTDPERS2,FW5F_LIVELLO2,FW5F_FLGSTDPERS3,FW5F_LIVELLO3,FW5F_FLGSTDPERS4,FW5F_LIVELLO4,FW5F_FLGSTDPERS5,FW5F_LIVELLO5,FW5F_INDTIPOVOCE,FW5F_DESCR,FW5F_IDVOCETS_FW50,FW5F_CODLICSTART,FW5F_CODLICEND,FW5F_CCVR,FW5F_FLGVISIBLE,FW5F_FLGMENU,FW5F_INDUSAGE,FW5F_DATAINS,FW5F_DATAMOD,FW5F_RELEASE,FW5F_RELEASEA)' +
							' VALUES (@FW5F_IDVOCEMENU,0,''' + @FW50_LIVELLO1 + ''',0,''' + @FW50_LIVELLO2 + ''',0,''' + @FW50_LIVELLO3 + ''',0,''' + @FW50_LIVELLO4_NEW + ''',0,''00 '',2,' + @FW50_DESCR + ',@FW50_IDVOCETS,' + @FW50_CODLICSTART + ',' + @FW50_CODLICEND + ',' + @FW5F_CCVR + ',' + @FW5F_FLGVISIBLE + ',1,0,''' + @FW5F_DATAINS + ''',''' + @FW5F_DATAMOD + ''',' + @FW5F_RELEASE + ', ' + @FW5F_RELEASEA + ')'

			EXECUTE sp_executesql @StrSql,
									N'@FW5F_IDVOCEMENU smallint, @FW50_IDVOCETS smallint',
									@FW5F_IDVOCEMENU = @FW5F_IDVOCEMENU, @FW50_IDVOCETS = @FW50_IDVOCETS
				
			if @CicloMenu = 1
				print 'Men ' + @FW50_DESCR + ' inserito correttamente'
			else
				print 'Men ' + @FW50_DESCR + ' (contabilit professionisti) inserito correttamente'
		end
		else
		begin
			if @CicloMenu = 1
				print 'Men ' + @FW50_DESCR + ' NON inserito!'
			else
				print 'Men ' + @FW50_DESCR + ' (contabilit professionisti) NON inserito!'
		end
	end
	
	set @CicloMenu = @CicloMenu + 1
end

set nocount off
go
